/** \file     dnf2bdd.c
 *  \brief    Conversion of DNF to BDD
 *  \author   Takahisa Toda
 *  \see      T.Toda, Dualization of Boolean functions Using Ternary Decision Diagrams, in Proc. of 13th International Symposium on Artificial Intelligence and Mathematics (ISAIM2014), Florida, USA(2014).
 */

#include "dnf2bdd.h"
#include "my_hash.h"
//#include "ssort2.h"


/** \brief    Receive DNF of a Boolean function and compute the BDD for the function.
 *  \param    sf    DNF represented using setfam data structure
 *  \return   pointer to BDD
 */
bddp dnf2bdd(struct setfam *sf)
{
    uintmax_t   m       = sf->card;
    format_eachrow(sf->elem, m);
  //  ssort2main(sf->elem, m);

    itemval **x = sf->elem;
    bddp f = bdd_bot();
    for (uintmax_t i = 0; i < m; i++) {
        int depth = 0;
        while (x[i][depth] != INFTY)
            depth++;
        bddp r = bdd_top();
        while(--depth >= 0) {
            itemval v = x[i][depth];
            if(v > 0)       r = bdd_node(v, bdd_bot(), r);
            else if (v < 0) r = bdd_node(-v, r, bdd_bot());
            else            {assert(0);}
            ENSURE_TRUE_MSG(r != BDD_NULL, "BDD operation failed");
        }
        f = bdd_or(r, f);
        ENSURE_TRUE_MSG(f != BDD_NULL, "BDD operation failed");
    }

    return f;
}
